jQuery(document).ready(function(){

	// Define variables
	var strPath;

	// Check current path, assign body.front for front page
	strPath = jQuery(location).attr('pathname');

	// Features on each page
	
	// Seach watermark
	$("form#ds-search-form label").inFieldLabels({fadeOpacity:1.0});

	// Call accordion plugin
	$( "#accordion" ).accordion({autoHeight:false});
	
	// Page-specific features
	if(strPath=='/'){

		// Call carouFredSel (from Nivo Studios)
		jQuery('body').addClass('front');
		jQuery('#slider').carouFredSel({
			width: 720,
			height: 180,
			items: {
				visible: 1,
				width: 720,
				height: 180
			},
			scroll: {
				easing: "linear",
				duration: 1000,
				pauseOnHover: true
			},
			auto: 10000,
			direction: "left",
			pagination: "#pagination"
		});

		// add "slide" styles
		jQuery("div#slider").addClass('slide');
		// add left class
		jQuery('#slider > div:first-child').addClass('left');

		// Load news items from Libraries' news API
		$.getJSON("//libraries.mit.edu/news/wp-json/wp/v2/posts?tags=162")
			.done(function(data, result) {

				var container = $("#research_news");
				var items = [];

				$.each( data, function( key, val ) {
					var itemDate = new Date(val.date);
					var dateFormat = {
						year: "numeric",
						month: "long",
						day: "numeric"
					};
					items.push( "<div class='ds-static-div newsitem'>" + 
						"<p class='ds-paragraph title'><a href='" + val.link + "'>" + val.title.rendered + "</a></h2>" +
						"<p class='ds-paragraph dateline'>" + itemDate.toLocaleDateString("en-us", dateFormat) + "</p>" +
						"<p class='ds-paragraph'>" + val.excerpt.rendered + "</p>" +
						"</div>"
					);
				});

				$("<div>", {
					"class": "post-list",
					html: items.join("")
				}).appendTo(container);

			})
			.fail(function() {
				console.log('Failure parsing news item feed');
			});

	} else {

		if(strPath=='/community-list') {
			// Call expanding tree on communities page
			jQuery("div#aspect_artifactbrowser_CommunityBrowser_div_comunity-browser > ul").treeview({
				collapsed: true,
				animated: "normal"
			});			
		}

		jQuery('.slider-wrapper').addClass('hidden');
	};

	// Change target for links in file submission process to open in new window
	$("#aspect_submission_StepTransformer_table_submit-upload-summary a").click(function() {
		var url = $(this).attr('href');
		window.open(url, '_blank');
		return false;
	});

});